#!/bin/sh

DPLY_PAGE_ADDITIONAL_SETTING_RESULT_MSG=""
DPLY_PAGE_ADDITIONAL_SETTING_RESULT_OK=0
DPLY_PAGE_ADDITIONAL_SETTING_RESULT_ERROR=1

DPLY_PAGE_ADDITIONAL_SETTING_RESULT_CODE=${DPLY_PAGE_ADDITIONAL_SETTING_RESULT_ERROR}
DPLY_PAGE_ADDITIONAL_SETTING_RESULT_ROLLING=0

dply_page_additional_setting() {
    debug_print "${0}" "${LINENO}" 'in function "dply_page_additional_setting"'

	local ret;
	ret=`php "${CONS_BACKEND}" sync_server_ip_to_controller "${RT_MS_IP}" 1`
	if [ "${?}" -ne 0 ]; then
        debug_print "${0}" "${LINENO}" "SyncMSIPToSC... Fail(${ret})"
        
	    DPLY_PAGE_ADDITIONAL_SETTING_RESULT_CODE=${DPLY_PAGE_ADDITIONAL_SETTING_RESULT_ERROR}
        DPLY_PAGE_ADDITIONAL_SETTING_RESULT_ROLLING=-2
        DPLY_PAGE_ADDITIONAL_SETTING_RESULT_MSG="${DPLY_PAGE_ADDITIONAL_SETTING_ERROR_SYNC_SETTING_TO_SC}"
		return
	fi
    debug_print "${0}" "${LINENO}" "SyncMSIPToSC... Success"
	sh notify_configuration_change.sh
    
    
    if [ "${RT_MASTER_MODE}" -eq 1 ]; then
        utility_switch_to_master_mode
        ret="${?}"
        if [ "${ret}" -ne 0 ]; then
            debug_print "${0}" "${LINENO}" "SwitchToMaster... Fail(${ret})"
            DPLY_PAGE_ADDITIONAL_SETTING_RESULT_CODE=${DPLY_PAGE_ADDITIONAL_SETTING_RESULT_ERROR}
            DPLY_PAGE_ADDITIONAL_SETTING_RESULT_ROLLING=-2
            DPLY_PAGE_ADDITIONAL_SETTING_RESULT_MSG="${DPLY_PAGE_ADDITIONAL_SETTING_ERROR_SWITCH_TO_MASTER_MODE}"
            return
        fi
        debug_print "${0}" "${LINENO}" "SwitchToMaster... Success"
    fi
    
    DPLY_PAGE_ADDITIONAL_SETTING_RESULT_CODE=${DPLY_PAGE_ADDITIONAL_SETTING_RESULT_OK}
    DPLY_PAGE_ADDITIONAL_SETTING_RESULT_ROLLING=1
    DPLY_PAGE_ADDITIONAL_SETTING_RESULT_MSG=""
    return
}